﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using System.Linq;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    /// <summary>
    /// Summary description for UnitTest1
    /// </summary>
    [TestClass]
    public class MilitaryServiceEpisodeImporterTests
    {
        MilitaryServiceEpisodeImporter _cut;
        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new MilitaryServiceEpisodeImporter();
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        //    [TestMethod]
        //    public void TestProcessSomething()
        //{
        //    List<REGISTRANT_SERVICE_EPISODE> emisEpisodes = new List<REGISTRANT_SERVICE_EPISODE>();
        //    int registrantId = 45;
        //    _cut.ProcessServiceEpisodes(emisEpisodes, registrantId);
        //}
        [TestMethod]
        public void CheckIfTwoEpisodesAreEqual()
        {
            var rseA = new REGISTRANT_SERVICE_EPISODE
            {
                REGISTRANT_ID = 1111,
                SERVICE_EPISODE_START_DATE = DateTime.Parse("2017-01-01"),
                SERVICE_EPISODE_END_DATE = DateTime.Parse("2017-02-02"),
                CREATED = DateTime.Parse("2017-12-28"),
                UPDATED = DateTime.Parse("2017-12-29")
            };
            var rseB = new REGISTRANT_SERVICE_EPISODE
            {
                REGISTRANT_ID = 1111,
                SERVICE_EPISODE_START_DATE = DateTime.Parse("2017-01-01"),
                SERVICE_EPISODE_END_DATE = DateTime.Parse("2017-02-02"),
                CREATED = DateTime.Parse("2017-12-28"),
                UPDATED = DateTime.Parse("2017-12-29")

            };
            var actual = rseA.Equals(rseB);
            Assert.AreEqual(true, actual);
        }

        [TestMethod]
        public void CheckIfTwoEpisodesHaveSameStartAndEndDates()
        {
            var rseA = new REGISTRANT_SERVICE_EPISODE
            {
                SERVICE_EPISODE_START_DATE = DateTime.Parse("2017-01-01"),
                SERVICE_EPISODE_END_DATE = DateTime.Parse("2017-02-02"),
            };
            var rseB = new REGISTRANT_SERVICE_EPISODE
            {
                SERVICE_EPISODE_START_DATE = DateTime.Parse("2017-01-01"),
                SERVICE_EPISODE_END_DATE = DateTime.Parse("2017-02-02"),
            };
            var actual = rseA.Equals(rseB);
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void GetMilitaryServiceEpisodes_Returns_An_Empty_List_When_No_ServiceEpisodes_Exist()
        {
            var edipi = "6001010112";
            var actual = _cut.GetMilitaryServiceEpisodes(edipi);
            Assert.IsNotNull(actual);
            Assert.AreEqual(0, actual.Count);
        }
        [TestMethod]
        public void GetMilitaryServiceEpisodes_Returns_A_List()
        {
            var edipi = "6001010004";
            var inputEdipi = new InputEdipiIcn();
            inputEdipi.edipiORicnValue = edipi;
            inputEdipi.inputType = InputEdipiIcnInputType.EDIPI;
            var input = new inputEdiPiOrIcn();
            input.edipiORicn = inputEdipi;

            //var inputHeaderInfo = new InputHeaderInfo();
            List<MilitaryServiceEpisode> actual = _cut.GetMilitaryServiceEpisodes(edipi);
            Assert.AreEqual(1, actual.Count);
        }

        [TestMethod]
        public void GetPersonnelCategoryCodes_Returns_A_List()
        {
            var edipi = "1005604067";
            var manager = new MilitaryServiceEpisodeManager();
            Dictionary<DateRange, string> actual = manager.GetPersonnelCategoryCodes(edipi);
            Assert.AreEqual(4, actual.Count);
        }

      
        [TestMethod]
        public void GetMilitaryServiceEpisodes_Response_Should_Have_One_Entry()
        {
            var edipi = "6001010004";
            var inputEdipi = new InputEdipiIcn();
            inputEdipi.edipiORicnValue = edipi;
            inputEdipi.inputType = InputEdipiIcnInputType.EDIPI;
            var input = new inputEdiPiOrIcn();
            input.edipiORicn = inputEdipi;

            var actual = _cut.GetMilitaryServiceEpisodesResponse(input, _cut.InputHeaderInfo);
            Assert.AreEqual(1, actual.militaryServiceEpisode.Length);
        }
        [TestMethod]
        public void GetMilitaryServiceEpisodes_When_No_Service_Episodes_Exist_Returned_List_Should_Not_Be_Null()
        {
            var invalidedipi = "6001010112";

            var actual = _cut.GetMilitaryServiceEpisodes(invalidedipi);
            Assert.IsNotNull(actual);
        }
       


    }
}
